<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Dashboard\AdminDashboardController;

// Route::get('/', function () {
//     return redirect(Auth::check() ? '/dashboard' : '/login');
// });


// Route::get('/', function () {
//     return view('welcome');
// });

// Route::get('/', function () {
//     if (!Auth::check()) return redirect('/login');

//     $user = Auth::user();

//     if ($user->hasRole('Admin')) return redirect()->route('admin.dashboard');
//     if ($user->hasRole('Hostel Warden')) return redirect()->route('warden.dashboard');
//     if ($user->hasRole('Mess Manager')) return redirect()->route('mess.dashboard');

//     return redirect('/login');
// });

// // Shared routes (all roles)
// Route::middleware('auth')->group(function () {
//     Route::get('/profile', function () {
//         return view('profile'); // shared profile page
//     })->name('profile');

//     Route::post('/logout', function () {
//         Auth::logout();
//         return redirect('/login');
//     })->name('logout');
// });


Route::get('/', function () {
    if (!Auth::check()) return redirect('/login');

    $user = Auth::user();

    if ($user->hasRole('Admin')) return redirect()->route('admin.dashboard');
    if ($user->hasRole('Hostel Warden')) return redirect()->route('warden.dashboard');
    if ($user->hasRole('Mess Manager')) return redirect()->route('mess.dashboard');
    
    return redirect('/login');
});

// Shared routes (all roles)
Route::middleware('auth')->group(function () {
    Route::get('/profile', function () {
        return view('profile'); // shared profile page
    })->name('profile');

    Route::post('/logout', function () {
        Auth::logout();
        return redirect('/login');
    })->name('logout');
});
