<!DOCTYPE html>
<html lang="en">


<head>
    <meta charset="UTF-8">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
    <title><?php echo Session::get('app_name'); ?></title>
    
    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <?php echo $__env->yieldContent('header'); ?>
    <link rel='shortcut icon' type='image/x-icon' href="<?php echo e(asset('asset/img/favicon.png')); ?>" style="width: 2px !important;" />
    <link rel="stylesheet" href="<?php echo e(asset('asset/css/app.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('asset/css/components.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('asset/css/custom.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('asset/bundles/codemirror/lib/codemirror.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('asset/bundles/codemirror/theme/duotone-dark.css')); ?> ">
    <link rel="stylesheet" href="<?php echo e(asset('asset/bundles/jquery-selectric/selectric.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('asset/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('asset/cdncss/iziToast.css')); ?>" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.css" />
    <link rel="stylesheet" href="<?php echo e(asset('asset/style/app.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('asset/css/style.css')); ?>">

</head>

<body>
    <div class="loader"></div>
    <div id="app">
        <div class="main-wrapper main-wrapper-1">
            <div class="navbar-bg"></div>
            <nav class="navbar navbar-expand-lg main-navbar sticky">
                <div class="form-inline mr-auto">
                    <ul class="navbar-nav mr-3">
                        <li>
                            <a href="#" data-toggle="sidebar" class="nav-link nav-link-lg collapse-btn">
                                <i data-feather="align-justify"></i>
                            </a>
                        </li>
                    </ul>
                </div>
                <ul class="navbar-nav navbar-right">
                    <li class="dropdown">
                        <a href="#" data-toggle="dropdown" class="nav-link dropdown-toggle nav-link-lg nav-link-user">
                            <span class="d-sm-none d-lg-inline-block btn btn-light"> 
                                <?php if(auth()->guard()->check()): ?>
                                <form method="POST" action="<?php echo e(route('logout')); ?>">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit">Logout</button>
                                </form>
                                <?php endif; ?> 
                            </span>
                        </a>
                        <div class="dropdown-menu dropdown-menu-right pullDown">
                            <?php if(auth()->guard()->check()): ?>
                                <form method="POST" action="<?php echo e(route('logout')); ?>">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit">Logout</button>
                                </form>
                                <?php endif; ?> 
                            
                                
                                <?php echo e(__('app.Logout')); ?>

                            </a>
                        </div>
                    </li>
                </ul>
            </nav>
            <div class="main-sidebar sidebar-style-2">
                <aside id="sidebar-wrapper">
                    <div class="sidebar-brand">
                        <a href="#">
                            <span class="logo-name"> <?php echo Session::get('app_name'); ?> </span>
                        </a>
                    </div>
                    <ul class="sidebar-menu">
                        <li class="menu-header"><?php echo e(__('app.Main')); ?></li>
                        <li class="sideBarli indexSideA">
                            <a href="#" class="nav-link">
                                <i class="fas fa-tachometer-alt pt-1"></i>
                                <span> <?php echo e(__('app.Dashboard')); ?></span>
                            </a>
                        </li>
                        <!-- <li class="sideBarli usersSideA">
                            <a href="#" class="nav-link">
                                <i class="fas fa-users"></i>
                                <span><?php echo e(__('app.Users')); ?></span>
                            </a>
                        </li>
                        <li class="sideBarli postSideA">
                            <a href="#" class="nav-link">
                                <i class="fas fa-image"></i>
                                <span> <?php echo e(__('app.Posts')); ?> </span>
                            </a>
                        </li>
                        <li class="sideBarli storySideA">
                            <a href="#" class="nav-link">
                                <i class="fas fa-compact-disc"></i>
                                <span> <?php echo e(__('stories')); ?> </span>
                            </a>
                        </li>
                        <li class="sideBarli liveapplicationSideA">
                            <a href="#" class="nav-link">
                                <i class="fas fa-rss"></i>
                                <span><?php echo e(__('app.Live_applications')); ?></span>
                            </a>
                        </li>
                        <li class="sideBarli livehistorySideA">
                            <a href="#" class="nav-link">
                                <i class="fas fa-rss"></i>
                                <span><?php echo e(__('app.Live_History')); ?></span>
                            </a>
                        </li>
                        <li class="sideBarli redeemrequestsSideA">
                            <a href="{#" class="nav-link"><i class="fas fa-university"></i><span><?php echo e(__('app.Redeem_Requests')); ?></span></a>
                        </li>
                        
                        <li class="sideBarli diamondpackSideA">
                            <a href="#" class="nav-link">
                                <i class="fas fa-box"></i>
                                <span><?php echo e(__('app.Diamond_packs')); ?></span>
                            </a>
                        </li>
                        <li class="sideBarli giftSideA">
                            <a href="#" class="nav-link">
                                <i class="fas fa-gift"></i>
                                <span><?php echo e(__('app.Gifts')); ?></span>
                            </a>
                        </li>
                        <li class="sideBarli verificationRequestSideA">
                            <a href="#" class="nav-link">
                                <i class="fas fa-check-circle"></i>
                                <span><?php echo e(__('app.Verification_requests')); ?></span>
                            </a>
                        </li>
                        <li class="sideBarli reportSideA">
                            <a href="#" class="nav-link">
                                <i class="fas fa-question"></i>
                                <span><?php echo e(__('app.Report')); ?></span>
                            </a>
                        </li>
                        <li class="sideBarli notificationSideA">
                            <a href="#" class="nav-link">
                                <i class="fas fa-bell"></i>
                                <span><?php echo e(__('app.Notifications')); ?></span>
                            </a>
                        </li>
                        <li class="sideBarli interestsSideA">
                            <a href="#" class="nav-link">
                                <i class="fas fa-heart"></i>
                                <span><?php echo e(__('app.Interests')); ?></span>
                            </a>
                        </li>
                        <li class="sideBarli otherSideA">
                            <a href="#">
                                <i class="fas fa-cog pt-1"></i>
                                <span><?php echo e(__('app.Setting')); ?></span>
                            </a>
                        </li>
                        <li class="menu-header"><?php echo e(__('Pages')); ?></li>
                        <li class="sideBarli  privacySideA">
                            <a href="#" class="nav-link">
                                <i class="fas fa-info"></i>
                                <span><?php echo e(__('Privacy Policy')); ?></span>
                            </a>
                        </li>
                        <li class="sideBarli  termsSideA">
                            <a href="#" class="nav-link">
                                <i class="fas fa-info"></i>
                                <span><?php echo e(__('Terms Of Use')); ?></span>
                            </a>
                        </li> -->
                    </ul>
                </aside>
            </div>
            <!-- Main Content -->
            <div class="main-content">
                <?php echo $__env->yieldContent('content'); ?>
                <form action="">
                    <input type="hidden" id="user_type" value="<?php echo e(session('user_type')); ?>">
                </form>
            </div>
        </div>
    </div>


    <input type="hidden" value="<?php echo e(env('APP_URL')); ?>" id="appUrl">

    <script src="<?php echo e(asset('asset/cdnjs/iziToast.min.js')); ?>"></script>
    <script src="<?php echo e(asset('asset/cdnjs/sweetalert.min.js')); ?>"></script>
    <script src="<?php echo e(asset('asset/script/env.js')); ?>"></script>
    <script src="<?php echo e(asset('asset/js/app.min.js ')); ?>"></script>
    <script src="<?php echo e(asset('asset/bundles/datatables/datatables.min.js ')); ?>"></script>
    <script src="<?php echo e(asset('asset/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('asset/bundles/jquery-ui/jquery-ui.min.js ')); ?>"></script>
    <script src="<?php echo e(asset('asset/js/bootstrap.min.js')); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.js"></script>
    <script src="<?php echo e(asset('asset/js/page/datatables.js')); ?>"></script>
    <script src="<?php echo e(asset('asset/js/scripts.js')); ?>"></script>
    <script src="<?php echo e(asset('asset/script/app.js')); ?>"></script>

    <!-- include summernote css/js -->
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>
    <script>
        $('#app_name').keyup(function() {
            let appName = $(this).val();
            $('.logo-name').text(appName);
            document.title = appName;
        });
    </script>
</body>

</html><?php /**PATH /Users/apple/Hostel/HostelCRM/resources/views/include/app.blade.php ENDPATH**/ ?>